"Macro Data Sheet file v. 1" 
gamesystem GURPS 

title "GURPS Magic (v. 3.0.0)"

version 253
level 3

copyright "Copyright  1989, 1990, 1994, 2001 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

$$define PLUGIN M

$$include gurps.inc

logo GURPS/Magic.lgo

define
	func "spLevCount(college, level)" "countItems(concat('Spells:', college), level-1, 1, 'level')"
	func "collegeSkill(college)"
		"min(20,integer(spLevCount(college, 12)+spLevCount(college, 16)*.5+spLevCount(college,20)*.5))"
	end

cat Advantages
	sublist "Occult and Paranormal Advantages" memlist
		$$ladv("Magery (Dance Magery)", Variable, thaumatology+x, "round(mc(x,&magery)/2)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery (Dark-Aspected Magery)", Variable, thaumatology+x, "round(mc(x,&magery)/2)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery (Moon-Aspected Magery)", Variable, thaumatology+x, "round(mc(x,&magery)/2)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery (Musical Magery)", Variable, thaumatology+x, "round(mc(x,&magery)/2)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery (Solitary Magery)", Variable, thaumatology+x, "round(mc(x,&magery)*16/25)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery (Song Magery)", Variable, thaumatology+x, "round(mc(x,&magery)*16/25)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery (Star-Aspected Magery)", Variable, thaumatology+x, "round(mc(x,&magery)/2)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery (Sun-Aspected Magery)", Variable, thaumatology+x, "round(mc(x,&magery)/2)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		end
	end

cat Skills 

	sublist Elixirs memlist
		## name, purpose, cat, matcost, time, skill, cost)
		sublist "Animal Control" memlist
			$$elixir	Cadmus	Dragonslaying	Animal Control	$600+	4 wks		$1300/$2000
			$$elixir	Ibycus	Bird Control	Animal Control	$200	2 wks		$550/$900
			$$elixir	Melampus	Beast-Speech	Animal Control	$300	3 wks		$850/$1350
			end
		sublist "Combat" memlist
			$$elixir	Achilles	Invulnerability	Combat	$1000	6 wks	-3	$2100/$3100
			$$elixir	Antaeus	Endurance	Combat	$300	6 wks		$1400/$2400
			$$elixir(Ares, the Warrior, Combat, $150, 2 wks, -1, $350/$700)
			$$elixir(Atalanta, Speed, Combat, $200, 3 wks, , $550/$850)
			$$elixir(Heracles, Strength, Combat, $100, 2 wks, -1, $250/$500)
			$$elixir(Hermes, Stealth, Combat, $300, 3 wks, -1, $500/$2000)
			$$elixir(Orion, the Huntsman, Combat, $200, 1 wks, , $300/$400)
			$$elixir(Theseus, Leadership, Combat, $400, 7 wks, , $1650/$2850)
			end
		sublist "Hostile" memlist
			$$elixir(Bellerophon, Odiousness, Hostile, $300, 4 wks, , $1000/$1700)
			$$elixir(Eris, Madness, Hostile, $100, 1 wks, , $200/$400)
			$$elixir(Juno, Jealousy, Hostile, "$50", 2 wks, , $400/$700)
			$$elixir(Narcissus, Self-Love, Hostile, $20, 4 wks, , $750/$1450)
			$$elixir(Nemesis, Hatred, Hostile, $125, 1 wk, , $300/$500)
			$$elixir(Phobos, Fear, Hostile, $50, 1 wk, , $225/$400)
			$$elixir(Philoctetes, Weakness, Hostile, $50, 2 wks, , $400/$750)
			$$elixir(Priapus, Lecherousness, Hostile, $200,  10 days, , $500/$700)
			$$elixir(Sisyphus, Frustration, Hostile, $100, 3 wks, , $650/$1150)
			$$elixir(Tantalus, Foolishness, Hostile, $150, 2 wks, , $500/$850)
			$$elixir(Thanatos, Death, Hostile, $100, 2 wks, , $500/$800)
			$$elixir(Tithonus, Aging, Hostile, $300, 3 wks, , $825/$1350)
			end
		sublist Magical memlist
			$$elixir(Agni, Fire Resistance, Magical, $300, 1 wks, , $500/$700)
			$$elixir(Circe, Transformation, Magical, $800, 12 wks, , $3000/$5000)
			$$elixir(Daedalus, Flight, Magical, $500, 10 wks, -2, $3000/$4700)
			$$elixir(Delphi, True Sight, Magical, $200, 4 wks, -1, $550/$1300)
			$$elixir(Ephialtes, Water-Walking, Magical, $150, 3 wks, , $700/$1200)
			$$elixir(Odysseus, Invisibility, Magical, $1000, 16 wks, -3, $3000/$6000)
			$$elixir(Poseidon, Water-Breathing, Magical, $50, 5 wks, -1, $600/$1000)
			$$elixir(Tyche, Luck, Magical, $200, 6 wks, -2, $1300/$2300)
			end
		sublist Medical memlist
			$$elixir(Aesculapius, Health, Medical, $200, 4 wks, -1, $750/$1200)
			$$elixir(Ceres, Fertility, Medical, $1500, 20 wks, -4, $6000/$11000)
			$$elixir(Chiron, Healing, Medical, $50, 1 wk, , $120/$250)
			$$elixir(Epimenides, Long Slumber, Medical, $4500, 25 wks, , $9000/$14000)
			$$elixir(Hebe, Youth, Medical, $6000, 50 wks, -8, $25000/$60000)
			$$elixir(Hydra, Regeneration, Medical, $300, 20 wks, -3, $5000/$11000)
			$$elixir(Janus, Antidote, Medical, 250$, 2 wks, -2, $400/$1000)
			$$elixir(Morpheus, Sleep, Medical, $50, 1 wk, , $120/$250)
			$$elixir(Persephone, Resurrection, Medical, $12000, 50 wks, -5, $25000/$40000)
			$$elixir(Pluto, Reanimation, Medical, $2000, 12 wks, -2, $4100/$6200)
			end
		sublist "Mental Abilities" memlist
			$$elixir(Apollo, Foreknowledge, Mental Abilities, $200, 10 wks, , $2000/$3700)
			$$elixir(Epmetheus, Memory, Mental Abilities, $400, 6 wks, , $1500/$2500)
			$$elixir(Orpheus, Charisma, Mental Abilities, $100, 3 wks, -1, $350/$550)
			$$elixir(Prometheus, Wisdom, Mental Abilities, $600, 5 wks, -1, $1500/$2400)
			end
		sublist "Mental Control" memlist
			$$elixir(Eros, Love, Mental Control, $600, 3 wks, -2, $900/$2000)
			$$elixir(Pan, Drunkenness, Mental Control, $100, 3 days, , $130/$300)
			$$elixir(Philemon, Friendship, Mental Control, $300, 2 wks, , $550/$1000)
			end
		sublist "Skills and Physical Abilities" memlist
			$$elixir(Argus, Vision, Physical Ability, $250, 10 days, , $400/$700)
			$$elixir(Marsyas, Music, Skill, $150, 4 days, , $300/$400)
			$$elixir(Syrinx, Hearing, Physical Ability, $125, 1 wk, , $300/$500)
			$$elixir(Vulcan, Craftsmanship, Skill, $400, 4 wks, -1, $1100/$1800)
			end
		end

	sublist "Magical" memlist
		$$skill("Magic Breath", PE, "Magical;Melee", "dx-2")
		$$skill("Magic Jet", PE, "Magical;Melee", "dx-4")
		sublist "Spell Throwing" memlist
			$$skill("Spell Throwing", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Ball)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Curse-Missile)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Ice Dagger)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Ice Sphere/Stone Missile)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Lightning)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Poltergeist)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Winged Knife)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			end
		sublist "Magic Nouns" memlist
			$$skill("Air", MVH, "Magic Nouns;Occult")
			$$skill("Animal", MVH, "Magic Nouns;Occult")
			$$skill("Body (Human)", MVH, "Magic Nouns;Occult")
			$$skill("Dark", MVH, "Magic Nouns;Occult")
			$$skill("Earth", MVH, "Magic Nouns;Occult")
			$$skill("Fire", MVH, "Magic Nouns;Occult")
			$$skill("Food", MVH, "Magic Nouns;Occult")
			$$skill("Image", MVH, "Magic Nouns;Occult")
			$$skill("Light", MVH, "Magic Nouns;Occult")
			$$skill("Magic", MVH, "Magic Nouns;Occult")
			$$skill("Mind (Human)", MVH, "Magic Nouns;Occult")
			$$skill("Plant", MVH, "Magic Nouns;Occult")
			$$skill("Sound", MVH, "Magic Nouns;Occult")
			$$skill("Spirit", MVH, "Magic Nouns;Occult")
			$$skill("Water", MVH, "Magic Nouns;Occult")
			end
		sublist "Magic Verbs" memlist
			$$skill("Communicate", MVH, "Magic Verbs;Occult")
			$$skill("Create", MVH, "Magic Verbs;Occult")
			$$skill("Heal", MVH, "Magic Verbs;Occult")
			$$skill("Move", MVH, "Magic Verbs;Occult")
			$$skill("Protect", MVH, "Magic Verbs;Occult")
			$$skill("Sense", MVH, "Magic Verbs;Occult")
			$$skill("Spellcrafting", MVH, "Magic Verbs;Occult")
			$$skill("Strengthen", MVH, "Magic Verbs;Occult")
			$$skill("Transform", MVH, "Magic Verbs;Occult")
			$$skill("Warn", MVH, "Magic Verbs;Occult")
			$$skill("Weaken", MVH, "Magic Verbs;Occult")
			end
		sublist "Runes" memlist
			$$skill("Rune: Air", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Animal", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Body (Man)", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Communicate", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Control", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Create", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Earth", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Fire", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Food", ME, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Heal", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Illusion", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Light/Dark", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Magic", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Mind", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Move", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Plant", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Protect", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Sense", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Sound", ME, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Strengthen", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Transform", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Undead (Spirit)", MH, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Warn", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Water", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune: Weaken", MA, "Rune", , "Skills:Rune-Lore>=12", )
			$$skill("Rune-Lore", MVH, "Rune", , "!Disadvantages:Non-Iconographic")
			end
		end
	end 

## Spell listings in comments are alternative prerequisites suggested in GURPS Grimoire (as "GMs
## may wish to change..."). To use these, simply swap the commented and real versions of the spell.
cat Spells 
	sublist "Air" memlist
		$$sp("Air Jet", , , "Air;*Combat", "1 sec.", "1 sec.", "1 to 3#", "Shape Air>=slc(12)", M34)
		$$sp("Body of Air", , "HT", "Air;*Shifting", "5 sec.", "1 min.", "4/1", "Shape Air>=slc(12)", M34)
		$$sp("Destroy Air", "Area", , "Air", "1 sec.", "Instant", "2", "Create Air>=slc(12)", M35)
		$$seespell	Earth to Air	Earth
		$$sp("No-Smell", , , "Air", "1 sec.", "1 hr.", "2#", "Purify Air>=slc(12)", M34)
		$$sp("Odor", "Area", , "Air", "1 sec.", "1 hr.#", "1", "No-smell>=slc(12)", M35)
		$$sp("Stench", "Area", , "Air", "1 sec.", "5 min.", "1#", "Purify Air>=slc(12)", M35)
		$$sp("Whirlwind", "Area", , "Air", "Instant#", "1 min.#", "4/2", "Windstorm>=slc(12)", M35)
		$$sp("Windstorm", "Area", , "Air", "Instant#", "1 min.#", "2/1", "Shape Air>=slc(12)", M35)
		$$sp("Windstorm", "Area", , "Air", "Instant#", "1 min.#", "2/1", "Wall of Wind>=slc(12)", M35)
			dsid ALTS
		end
	sublist "Animal" memlist
		$$sp("Beast Link", , , "Animal", "5 sec.", "Special", "3", "Beast Summoning>=slc(12)", M23, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Beast Possession", , "IQ", "Animal", "5 sec.", "1 min.", "6/2", "Rider Within>=slc(12)|Possession>=slc(12)", M24, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Beast Seeker", "Information", , "Animal;*Seek", "1 sec.", "Instant", "3#", "Beast Summoning>=slc(12);#2,Sp:*Seek>=slc(12)|Seeker>=slc(12)", M23, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Beast Speech", , , "Animal", "1 sec.", "1 min.", "4/2", "Beast Summoning>=slc(12)", M25, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Fish Control", , "IQ", "Animal;*Animal Control", "1 sec.", "1 min.", "3/2", "Beast-Soother>=slc(12)", M24, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Insect Control", , "IQ", "Animal;*Animal Control", "1 sec.", "1 min.", "3/2", "Beast-Soother>=slc(12)", M24, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Master", "Regular or Blocking", "IQ", "Animal", "1 sec.", "Indef.", "2", "Beast-Soother>=slc(12)", M23, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Mollusk Control", , "IQ", "Animal;*Animal Control", "1 sec.", "1 min.", "3/2", "Beast-Soother>=slc(12)", M24, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Rider", , , "Animal", "1 sec.", "5 min.", "2/1", "#1,Sp:*Animal Control>=slc(12)", M24, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Rider Within", , , "Animal", "3 sec.", "1 min.", "4/1", "#2,Sp:*Animal Control>=slc(12)", M24, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		sublist "Shapeshift Others" memlist
			$$sp("Shapeshift Others*", "Special", "IQ", "Animal;*Shifting;*Shapeshift Others", "30 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=2;Shapeshifting>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshift Others (Wolf)*", "Special", "IQ", "Animal;*Shifting;*Shapeshift Others", "30 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=2;Shapeshifting (Wolf)>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshift Others (Bear)*", "Special", "IQ", "Animal;*Shifting;*Shapeshift Others", "30 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=2;Shapeshifting (Bear)>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshift Others (Boar)*", "Special", "IQ", "Animal;*Shifting;*Shapeshift Others", "30 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=2;Shapeshifting (Boar)>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshift Others (Giant Eagle)*", "Special", "IQ", "Animal;*Shifting;*Shapeshift Others", "30 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=2;Shapeshifting (Giant Eagle)>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshift Others (Tiger)*", "Special", "IQ", "Animal;*Shifting;*Shapeshift Others", "30 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=2;Shapeshifting (Tiger)>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshift Others (Giant Snake)*", "Special", "IQ", "Animal;*Shifting;*Shapeshift Others", "30 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=2;Shapeshifting (Giant Snake)>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			end
		sublist "Shapeshifting" memlist
			$$sp("Shapeshifting*", "Special", , "Animal;*Shifting;*Shapeshifting", "3 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=1;#6,Spells>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshifting (Wolf)*", "Special", , "Animal;*Shifting;*Shapeshifting", "3 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=1;#6,Spells>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshifting (Bear)*", "Special", , "Animal;*Shifting;*Shapeshifting", "3 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=1;#6,Spells>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshifting (Boar)*", "Special", , "Animal;*Shifting;*Shapeshifting", "3 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=1;#6,Spells>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshifting (Giant Eagle)*", "Special", , "Animal;*Shifting;*Shapeshifting", "3 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=1;#6,Spells>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshifting (Tiger)*", "Special", , "Animal;*Shifting;*Shapeshifting", "3 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=1;#6,Spells>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Shapeshifting (Giant Snake)*", "Special", , "Animal;*Shifting;*Shapeshifting", "3 sec.", "1 hr.", "6/2", "#1,Adv:Magery>=1;#6,Spells>=slc(12)", M25,
				"BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			end
		end
	sublist "Body Control" memlist
		$$sp("Alter Body", , "HT", "Body Control;*Shifting", "2 min.", "1 hr.#", "8/6#", "Alter Visage>=slc(12)", M28)
		$$sp("Alter Visage", , "HT", "Body Control;*Shifting", "1 min.", "1 hr.#", "4/3#", "#8,Sp:Body Control>=slc(12)~Shapeshifting>=slc(12)|Perfect Illusion>=slc(12)", M28)
		$$sp("Climbing", , , "Body Control", "1 sec.", "1 min.", "1 to 3/s", , M26)
		$$sp("Clumsiness", , "IQ", "Body Control;*Combat", "1 sec.", "1 min.", "varies#", "Spasm>=slc(12)", M26)
		$$sp("Curse-Missile", "Missile", , "Body Control;*Combat", "1 sec.+other spell#", "varies#", "2", "#1,Adv:Magery>=2", M27)
		$$sp("Deathtouch", , , "Body Control;*Combat", "1 sec.", "Instant", "1 to 3", "Wither Limb>=slc(12)", M27)
		$$sp("Dexterity", , , "Body Control;*Combat", "1 sec.", "1 min.", "2 per DX+/s", "Clumsiness>=slc(12)", M26)
		$$sp("Fatigue", , "HT", "Body Control;*Combat", "1 sec.", "1 min.", "1 per ST-/h", , M27)
		$$sp("Hinder", , "HT", "Body Control;*Combat", "1 sec.", "1 min.", "1 to 4/s", "Haste>=slc(12)", M27)
		$$sp("Itch", , "HT", "Body Control", "1 sec.", "scratch#", "2", , M25)
		$$sp("Might", , , "Body Control;*Combat", "1 sec.", "1 min.", "2 per ST +/s", "Lend Strength>=slc(12)", M26)
		$$sp("Pain", , "HT", "Body Control;*Combat", "2 sec.", "1 sec.", "2", "Spasm>=slc(12)", M26)
		$$sp("Paralyze Limb", , "HT", "Body Control;*Combat", "1 sec.", "1 min.", "3#", "#1,Adv:Magery>=1;#5,Sp:Body Control>=slc(12);Pain>=slc(12)", M27)
		$$sp("Resist Pain", , , "Body Control;*Combat", "1 sec.", "1 min.", "4/2", "Pain>=slc(12);#1,Adv:Magery>=2", M28)
		$$sp("Rooted Feet", , "ST", "Body Control;*Combat", "1 sec.", "1 min.#", "3", "Hinder>=slc(12)", M27)
		$$sp("Roundabout", , "HT", "Body Control", "1 sec.", "Instant", "3", "Tanglefoot>=slc(12)", M27)
		$$seespell	Sickness	Mind Control
		$$sp("Spasm", , "HT", "Body Control;*Combat", "1 sec.", "a moment", "2", "Itch>=slc(12)", M25)
		$$sp("Strike Blind", , "HT", "Body Control;*Combat", "1 sec.", "10 sec.", "4/2", "#2,Sp:Light and Darkness>=slc(12);Spasm>=slc(12)", M26)
		$$sp("Strike Deaf", , "HT", "Body Control;*Combat", "1 sec.", "10 sec.", "3/1", "#2,Sp:Sound>=slc(12);Spasm>=slc(12)", M26)
		$$sp("Strike Dumb", , "HT", "Body Control;*Combat", "1 sec.", "10 sec.", "3/1", "Spasm>=slc(12)", M26)
		$$sp("Stun", , "HT", "Body Control;*Combat", "1 sec.", "Instant", "2", "Pain>=slc(12)", M26)
		$$sp("Tanglefoot", , "DX", "Body Control;*Combat", "1 sec.", "Instant", "2", "Clumsiness>=slc(12)", M27)
		$$sp("Total Paralysis", , "HT", "Body Control;*Combat", "1 sec.", "1 min.", "5#", "Paralyze Limb>=slc(12)", M27)
		$$sp("Vigor", , , "Body Control", "1 sec.", "1 min.", "2 per HT+/s#", "Lend Health>=slc(12)", M26)
		$$sp("Vigor", , , "Body Control", "1 sec.", "1 min.", "2 per HT+/s#", "Lend Health>=slc(12)|Frailty>=slc(12)", M26)
			dsid ALTS
		$$sp("Wither Limb", , "HT", "Body Control;*Combat", "1 sec.", "Perm.", "5", "#1,Adv:Magery>=2;Paralyze Limb>=slc(12)", M27)
		end
	sublist "Communication and Empathy" memlist
		$$sp("Borrow Language", , , "Communication and Empathy", "3 sec.", "1 min.", "3/1", "Lend Language>=slc(12)", M30)
		$$sp("Borrow Skill", , , "Communication and Empathy", "3 sec.", "1 min.", "4/3", "Lend Skill>=slc(12)", M30)
		$$sp("Compel Truth", "Information", "IQ", "Communication and Empathy", "1 sec.", "5 min.", "4/2", "#1,Adv:Magery>=2;Truthsayer>=slc(12)", M28)
		$$sp("Control Person", , "IQ", "Communication and Empathy", "10 sec.", "1 min.", "6/3", "Soul Rider>=slc(12)|Telepathy>=slc(12)", M29)
		$$sp("Exchange Bodies*", , "IQ", "Communication and Empathy", "1 hr.", "Perm.", "120", "Permanent Possession>=slc(12);Soul Jar>=slc(12)", M30)
		$$sp("Exorcism", , "spell", "Communication and Empathy", "10 sec.", "Instant", "10", "Soul Rider>=slc(12)|Possession>=slc(12)|Adv:Clerical Investment", M30)
		$$sp("Gift of Letters*", , , "Communication and Empathy", "1 sec.", "1 min.", "4/2", "Borrow Language>=slc(12);#3,Sk:Language>=slc(12)", M30)
		$$sp("Gift of Tongues*", , , "Communication and Empathy", "1 sec.", "1 min.", "4/2", "Borrow Language>=slc(12);#3,Sk:Language>=slc(12)", M30)
		$$sp("Hide Thoughts", , , "Communication and Empathy", "1 sec.", "10 min.", "3/1", "Truthsayer>=slc(12)|Hide Emotion>=slc(12)", M29)
		$$sp("Lend Language", , , "Communication and Empathy", "3 sec.", "1 min.", "3/1", "Mind-Sending>=slc(12)", M30)
		$$sp("Lend Skill", , , "Communication and Empathy", "3 sec.", "1 min.", "3/2", "Mind-Sending>=slc(12);Main:IQ>=12", M30)
		$$sp("Mind-Search*", , "IQ", "Communication and Empathy", "1 min.", "1 min.", "6/3", "Mind-Reading>=slc(12)", M29)
		$$sp("Mind-Sending", , , "Communication and Empathy", "4 sec.", "1 min.", "4/4", "Mind-Reading>=slc(12)", M29)
		$$sp("Permanent Possession*", , "IQ", "Communication and Empathy", "5 min.", "Indef.", "30", "#1,Adv:Magery>=3;Possession>=slc(12)", M30)
		$$sp("Possession*", , "IQ", "Communication and Empathy", "1 min.", "1 min.", "10/4", "#1,Adv:Magery>=1~Control Person>=slc(12)|Beast Possession>=slc(12)", M30)
		$$sp("Soul Rider", , "IQ", "Communication and Empathy", "3 sec.", "1 min.", "5/2", "Mind-Reading>=slc(12)", M29)
		$$sp("Telepathy*", , , "Communication and Empathy", "4 sec.", "1 min.", "4/4#", "Mind-Sending>=slc(12)", M29)
		end
	sublist "Earth" memlist
		$$sp("Body of Stone", , "HT", "Earth;*Shifting", "5 sec.", "1 min.", "10/hex#", "Stone to Flesh>=slc(12)", M32)
		$$sp("Earthquake", "Area", , "Earth", "30 sec.", "1 min.", "2/2", "#1,Adv:Magery>=2;#6,Sp:Earth>=slc(12);Earth Vision>=slc(12)", M33)
		$$sp("Entombment", , "HT", "Earth", "3 sec.", "Perm.", "10#", "#1,Adv:Magery>=2;#5,Sp:Earth>=slc(12)", M32)
		$$sp("Flesh to Stone", , "HT", "Earth;*Transmutation", "2 sec.", "Perm.", "10/hex#", "Earth to Stone>=slc(12)", M32)
		$$sp("Sand Jet", , , "Earth;*Combat", "1 sec.", "1 sec.", "1 to 3/s", "Create Earth>=slc(12);Shape Earth>=slc(12)", M31)
		$$sp("Shape Stone", , , "Earth;*Shape", "1 sec.", "1 min.", "4/hex/2/hex#", "Shape Earth>=slc(12);#4,Sp:Earth>=slc(12)", M31)
		$$sp("Stone to Flesh", , , "Earth;*Transmutation", "5 sec.", "Perm.", "10/hex#", "#1,Adv:Magery>=2;Stone to Earth>=slc(12);Flesh to Stone>=slc(12)", M32)
		$$sp("Volcano", , , "Earth", "1 hr.#", "1 day", "15/10", "Earthquake>=slc(12);#6,Sp:Fire>=slc(12)", M33)
		$$sp("Walk Through Earth", , , "Earth", "1 sec.", "1 sec.", "4/3#", "Shape Stone>=slc(12)", M31)
		end
	sublist "Enchantment" memlist
		$$sp("Golem*", "Enchantment", , "Enchantment", "varies#", "Perm.", "varies#", "Shape Earth>=slc(12);Animation>=slc(12)", M44)
		$$sp("Great Wish*", "Enchantment", , "Enchantment", , , "2,000", "#1,Adv:Magery>=3;Wish>=slc(12);$DX+IQ>=30", M44)
		$$sp("Hex", "Enchantment", , "Enchantment", , "Perm.", "200", "Enchant>=slc(12)", M43)
		$$sp("Hideaway", "Enchantment", , "Enchantment", , "Perm.", "50#", "Create Object>=slc(12);Lighten>=slc(12)", M44)
		$$sp("Lesser Wish*", "Enchantment", , "Enchantment", , , "180", "#1,Adv:Magery>=1;#1,10,Sp>=slc(12)", M43)
		$$sp("Speed", "Enchantment", , "Enchantment", , "Perm.", "500#", "Haste>=slc(12)", M43)
		$$sp("Suspend Enchantment", "Enchantment", , "Enchantment", "1 sec.", "1 hr.", "25#", "Enchant>=slc(12)", M43)
		$$sp("Wish*", "Enchantment", , "Enchantment", , , "250", "#1,Adv:Magery>=2;Lesser Wish>=slc(12);#1,15,Spells>=slc(12)", M43)
		$$seespell	Link	Meta-Spell
		sublist "Weapon Enchantments" memlist
			$$sp("Quick-Draw", "Enchantment", , "Enchantment;*Weapon Enchantment", , "Perm.", "300/lb.#", "Apportation>=slc(12)", M44)
			$$sp("Dancing Weapon", "Enchantment", , "Enchantment;*Weapon Enchantment", , "Perm.", "1,000/lb.#", "Air-Golem>=slc(12)", M45)
			$$sp("Loyal Sword", "Enchantment", , "Enchantment;*Weapon Enchantment", , "Perm.", "750/lb.#", "Apportation>=slc(12)", M45)
			$$sp("Cornucopia", "Enchantment", , "Enchantment;*Weapon Enchantment", , "Perm.", "50 x $ value#", "#1,Adv:Magery>=2;#2,Spells:Weapon Enchantment>=slc(12)", M45)
			$$sp("Bane", "Enchantment", , "Enchantment;*Weapon Enchantment", , "Perm.", "100#", "Enchant>=slc(12)", M45)
			end
		sublist "Limiting Enchantments" memlist
			$$sp("Name", "Enchantment", , "Enchantment", , "Perm.", "200 or 400#", "Enchant>=slc(12)", M46)
			$$sp("Password", "Enchantment", , "Enchantment", , "Perm.", "400#", "Enchant>=slc(12)", M46)
			$$sp("Limit", "Enchantment", , "Enchantment", , "Perm.", "200", "Enchant>=slc(12)", M46)
			end
		sublist "Wizardly Tools" memlist
			$$sp("Crystal Ball", "Enchantment", , "Enchantment", , "Perm.", "1,000", "Divination (Crystal-Gazing)>=slc(12)", M47)
			end
		end
	sublist "Fire" memlist
		$$sp("Breathe Fire*", , , "Fire;*Combat", "2 sec.", "1 sec.", "1 to 4", "#1,Adv:Magery>=1;Flame Jet>=slc(12);Resist Fire>=slc(12)", M38)
		$$sp("Essential Flame", "Area", , "Fire", "3 sec.", "1 min.", "3/2#", "#6,Sp:Fire>=slc(12)", M38)
		$$sp("Explosive Fireball", "Missile", , "Fire;*Combat", "1 sec.", "Instant", "2 to 6#", "Fireball>=slc(12)", M38)
		$$sp("Fireproof", "Area", , "Fire", "5 min.", "1 day", "3#", "Extinguish Fire>=slc(12)", M37)
		$$sp("Flame Jet", , , "Fire;*Combat", "1 sec.", "1 sec.", "1 to 3/s#", "Create Fire>=slc(12);Shape Fire>=slc(12)", M38)
		$$sp("Flaming Missiles", , , "Fire;*Combat", "3 sec.", "1 min.", "4/2#", "Flaming Weapon>=slc(12)", M38)
		$$sp("Flaming Weapon", , , "Fire;*Combat", "2 sec.", "1 min.", "4/1", "#1,Adv:Magery>=2;Heat>=slc(12)", M38)
		$$sp("Phantom Flame", "Area", , "Fire", "1 sec.", "1 min.", "1/1", "Shape Fire>=slc(12)|Simple Illusion>=slc(12)", M38)
		$$sp("Resist Cold", , , "Fire", "1 sec.", "1 min.", "2/hex#", "Create Fire>=slc(12);Heat>=slc(12)", M37)
		end
	sublist "Food" memlist
		$$sp("Banquet", , , "Food", "1 sec.", "1 day", "2 per meal", "#1,Adv:Magery>=1;Cook>=slc(12);Foolishness>=slc(12)", M49)
		$$sp("Cook", , , "Food", "5 sec.", "Instant", "1 per meal", "Test Food>=slc(12);Create Fire>=slc(12)", M48)
		$$sp("Create Food", , , "Food;*Create", "30 sec.", "Perm.", "3/meal#", "Cook>=slc(12);Seek Food>=slc(12)", M48)
		$$sp("Decay/TL", , , "Food", "1 sec.", "Perm.", "1/meal", "Test Food>=slc(12)", M48)
		$$sp("Distill", , , "Food", "10 sec.", "Perm.", "1/quart", "Ferment>=slc(12);Destroy Water>=slc(12)", M49)
		$$sp("Ferment", , , "Food", "10 sec.", "1 hr.", "1 per pint or loaf", "Decay>=slc(12)", M48)
		$$sp("Monk's Banquet", , , "Food", "1 sec.", "24 hrs.", "6", "Banquet>=slc(12);Resist Pain>=slc(12)", M49)
		$$sp("Poison Food", , , "Food", "1 sec.", "Perm.", "3 per meal", "Purify Food>=slc(12);Decay>=slc(12)", M48)
		$$sp("Preserve Food", , , "Food", "1 sec.", "1 week", "Special", "Sterilize>=slc(12);Test Food>=slc(12)", M48)
		$$sp("Purify Food", , , "Food", "1 sec.", "Perm.", "1 per lb.", "Preserve Food>=slc(12)|Decay>=slc(12)", M48)
		$$sp("Seek Food", "Information", , "Food;*Seek", "1 sec.", "Instant", "2", , M48)
		$$sp("Test Food", "Information", , "Food", "1 sec.", "Instant", "1 to 3#", , M48)
		$$sp("Water to Wine", , , "Food;*Transmutation", "10 sec.", "Perm.", "4 per gal.#", "Purify Water>=slc(12);Ferment>=slc(12)", M49)
		end
	sublist Gate memlist
		$$seespell	Banish	Necromantic
		$$seespell	Blink	Movement
		$$seespell	Planar Summons	Necromantic
		$$seespell	Summon Demon	Necromantic
		$$seespell	Teleport*	Movement
		$$seespell	Teleport Other*	Movement
		$$seespell	Teleport Shield	Protection and Warning
		end
	sublist "Healing" memlist
		$$sp("Cure Disease", , , "Healing", "10 min.#", "Instant", "4#", "Sterilize>=slc(12);Major Healing>=slc(12)", M50)
		$$sp("Cure Disease", , , "Healing", "10 min.#", "Instant", "4#", "Resist Disease>=slc(12);Major Healing>=slc(12)", M50)
				dsid ALTS
		$$sp("Halt Aging*", , , "Healing", "1 sec.", "5d days", "20#", "#6,Sp:Healing>=slc(12);#1,Adv:Magery>=2", M51)
		$$sp("Instant Regeneration*", , , "Healing", "Special", "Perm.", "80#", "Regeneration>=slc(12);#1,Adv:Magery>=3", M51)
		$$sp("Instant Restoration*", , , "Healing", "Special", "Perm.", "50#", "Restoration>=slc(12);#1,Adv:Magery>=2", M51)
		$$sp("Neutralize Poison", , , "Healing", "30 sec.", "Perm.", "5#", "Cure Disease>=slc(12)|#1,Adv:Magery>=3;Test Food>=slc(12)", M50)
		$$sp("Regeneration*", , , "Healing", "Special#", "Perm.", "20#", "Restoration>=slc(12);#1,Adv:Magery>=2", M51)
		$$sp("Restoration*", , , "Healing", "1 min.#", "Perm.", "15#", "Major Healing>=slc(12)|#2,Sp:*Restore>=slc(12)", M51)
		$$sp("Resurrection*", , , "Healing;Necromantic", "6 hrs.", "Perm.", "300#", "Instant Regeneration>=slc(12);Summon Spirit>=slc(12)", M51)
		$$sp("Share Strength", , , "Healing", "1 sec.", "Special", "varies#", "Lend Strength>=slc(12)", M50)
		$$sp("Sterilize", "Area", , "Healing", "varies#", "Instant", "3/hex#", "Decay>=slc(12)|Insect Control>=slc(12)", M50)
		$$sp("Suspended Animation", , "HT", "Healing", "30 sec.", "Indef.#", "6", "Sleep>=slc(12);#4,Sp:Healing>=slc(12)", M50)
		$$sp("Youth*", , , "Healing", "1 sec.", "Special", "100#", "Halt Aging>=slc(12);#1,Adv:Magery>=3", M51)
		end
	sublist "Illusion and Creation" memlist
		$$sp("Complex Illusion", "Area", , "Illusion and Creation", "1 sec.", "1 min.", "2/1", "Sound>=slc(12);Simple Illusion>=slc(12)", M51)
		$$sp("Control Creation", , "spell", "Illusion and Creation", "2 sec.", "Instant", "1 per hex#", "Create Animal>=slc(12)|Create Servant>=slc(12)", M52)
		$$sp("Control Illusion", , "spell", "Illusion and Creation", "2 sec.", "Perm.", "1/hex#", "Perfect Illusion>=slc(12)", M52)
		$$sp("Create Animal", , , "Illusion and Creation;*Create", "sec.=cost", "1 min.", "varies#", "Create Water>=slc(12);Create Object>=slc(12);Main:IQ>=13", M52)
		$$sp("Create Object*", , , "Illusion and Creation;*Create", "sec.=cost", "Indef.", "2/5 lbs", "#1,Adv:Magery>=2;Create Earth>=slc(12);Perfect Illusion>=slc(12)", M52)
		$$sp("Create Servant", , , "Illusion and Creation;*Create", "3 sec.", "1 min.", "3/1#", "#1,Adv:Magery>=3;Main:IQ>=13;Create Object>=slc(12)", M52)
		$$sp("Create Warrior", , , "Illusion and Creation;*Create", "4 sec.", "1 min.", "4/4#", "Create Servant>=slc(12)", M52)
		$$sp("Dispel Creation", , "spell", "Illusion and Creation", "1 sec.", "Instant", "1 per hex#", "Control Creation>=slc(12)", M53)
		$$sp("Dispel Illusion", , "spell", "Illusion and Creation", "1 sec.", "Instant", "1/hex", "Control Illusion>=slc(12)", M52)
		$$sp("Illusion Disguise", , , "Illusion and Creation", "1 sec.", "varies#", "3", "Simple Illusion>=slc(12)", M52)
		$$sp("Illusion Shell", , , "Illusion and Creation", "1 sec.", "1 min.", "2/hex#", "Simple Illusion>=slc(12)", M51)
		$$sp("Independence", "Area", , "Illusion and Creation", "varies#", "varies#", "2", "Simple Illusion>=slc(12)", M53)
		$$sp("Know Illusion", "Information", , "Illusion and Creation", "1 sec.", "Instant", "2", "Simple Illusion>=slc(12)", M53)
		$$sp("Perfect Illusion", "Area", , "Illusion and Creation", "1 sec.", "1 min.", "3/h.#", "#1,Adv:Magery>=1;Complex Illusion>=slc(12)", M51)
		$$sp("Simple Illusion", "Area", , "Illusion and Creation", "1 sec.", "1 min.", "1/half", "!Dis:Blindness;!Dis:Bad Sight;Main:IQ>=11", M51)
		end
	sublist "Knowledge" memlist
		$$sp("Alarm", , , "Knowledge", "1 sec.", "1 week", "1#", "Tell Time>=slc(12)", M53)
		$$sp("Ancient History", "Information", , "Knowledge", "1 min.#", "Instant", "varies#", "History>=slc(12)", M54)
		sublist "Divination" memlist
			$$sp("Divination", "Information", , "Knowledge", "1hr.#", "Instant", "10", "History>=slc(12)|Adv:Blessed", M55)
			$$sp("Divination (Astrology)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#10,Sp:Air>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Cartomancy)", "Information", , "Knowledge;*Divination", , , , "History>=slc(12);#3,Sp:Air>=slc(12);#3,Sp:Earth>=slc(12);#3,Sp:Water>=slc(12);#3,Sp:Fire>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Crystal-Gazing)", "Information", , "Knowledge;*Divination", , , , "History>=slc(12);#5,Sp:Earth>=slc(12);#5,Sp:Water>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Haruspication)", "Information", , "Knowledge;*Divination", , , , "History>=slc(12);#10,Sp:Earth>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Molybdomancy)", "Information", , "Knowledge;*Divination", , , , "History>=slc(12);#5,Sp:Fire>=slc(12);#5,Sp:Water>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Oneiromancy)", "Information", , "Knowledge;*Divination", , , , "History>=slc(12);#5,Sp:Air>=slc(12);#5,Sp:Water>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Pyromancy)", , , "Knowledge;*Divination", , , , "History>=slc(12);#10,Sp:Fire>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Rune-casting)", "Information", , "Knowledge;*Divination", , , , "History>=slc(12);#1,Adv:Magery>=1;Skills:Rune-Lore>=15|Adv:Blessed", M56)
			$$sp("Divination (Dactylomancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#3,Sp:Air>=slc(12);#3,Sp:Earth>=slc(12);#3,Sp:Fire>=slc(12);#3,Sp:Water>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Arithmancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Adv:Blessed|History>=slc(12)~#8,Sp:Air>=slc(12)|Adv:Mathematical Ability|Adv:Blessed", M56)
			$$sp("Divination (Chiromancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#4,Sp:Air>=slc(12);#4,Sp:Earth>=slc(12);#4,Sp:Fire>=slc(12);#4,Sp:Water>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Graphology)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#6,Sp:Air>=slc(12);#6,Sp:Earth>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Lunomancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#5,Sp:Air>=slc(12);#2,Sp:Earth>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Pedomancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#4,Sp:Earth>=slc(12);#2,Sp:Water>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Geomancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#10,Sp:Earth>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Aeromancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#10,Sp:Air>=slc(12)|Adv:Blessed", M56)
			$$sp("Divination (Hydromancy)", "Information", , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#10,Sp:Water>=slc(12)|Adv:Blessed", M57)
			$$sp("Divination (Astragyromancy)", , , "Knowledge;*Divination", "20 min.#", "Instant", "10", "History>=slc(12);#6,Sp:Air>=slc(12);#6,Sp:Earth>=slc(12);#6,Sp:Fire>=slc(12);#6,Sp:Water>=slc(12)|Adv:Blessed", M57;G59)
			$$sp("Divination (Belomancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Divination (Aeromancy)>=15|Adv:Blessed", M57;G60)
			$$sp("Divination (Botanomancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#4,Sp:Fire>=slc(12);#4,Sp:Plant>=slc(12)|Adv:Blessed", M57G60)
			$$sp("Divination (Gastromancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);Skill:Hypnotism>=15;#3,Sp:Air>=slc(12);#3,Sp:Earth>=slc(12);#3,Sp:Fire>=slc(12);#3,Sp:Water>=slc(12)|Adv:Blessed", M57;G60)
			$$sp("Divination (Lithomancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#2,Sp:Water>=slc(12);#5,Sp:Earth>=slc(12)|Adv:Blessed", M57;G60)
			$$sp("Divination (Libranomancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Adv:Blessed|History>=slc(12)~#4,Sp:Air>=slc(12);#4,Sp:Earth>=slc(12);#4,Sp:Fire>=slc(12);#4,Sp:Water>=slc(12)|#7,Sp:Fire>=slc(12);#7,Sp:Air>=slc(12)|Adv:Blessed", M57;G60)
			end
		$$sp("Find Direction", "Information", , "Knowledge", "1 sec.", "Instant", "2", "#1,Adv:Magery>=1", M53)
		$$sp("Glass Wall", , , "Knowledge", "1 sec.", "1 min.", "4/2", "#5,Sp:Knowledge>=slc(12)|Earth Vision>=slc(12)", M55)
		$$sp("History", "Information", , "Knowledge", "sec. = cost", "Instant", "varies#", "Trace>=slc(12)", M54)
		$$sp("Invisible Wizard Eye", , , "Knowledge;*Thief", "4 sec.", "1 min.", "5/3", "Wizard Eye>=slc(12);Invisibility>=slc(12)", M54)
		$$sp("Mage Sense", "Information", , "Knowledge", "1 sec.", "1 min.", "3/2", "Detect Magic>=slc(12)", M55)
		$$sp("Mage Sight", , , "Knowledge", "1 sec.", "1 min.", "3/2", "Detect Magic>=slc(12)", M54)
		$$sp("Pathfinder", "Information", , "Knowledge", "10 sec.", "Instant", "4#", "#1,Adv:Magery>=1;Main:IQ>=12;#2,Sp:*Seek>=slc(12)", M54)
		$$sp("See Secrets", , , "Knowledge", "5 sec.", "1 min.", "5/2", "Seeker>=slc(12);Aura>=slc(12)", M54)
		$$sp("Tell Time", "Information", , "Knowledge", "1 sec.", "Instant", "1", , M53)
		$$sp("Wizard Eye", , , "Knowledge", "2 sec.", "1 min.", "4/2", "#1,Adv:Magery>=1;Apportation>=slc(12);Keen Eyes>=slc(12)", M54)
		$$sp("Measurement/TL", "Area;Information", , "Knowledge;*Technological;*Machine;*Energy;*Radiation;*Metal/Plastic", , Instant, 1, , "M54;G95")
		$$seespell	Earth Vision	Earth
		$$seespell	Far-Hearing	Sound
		$$seespell	Ice Vision	Water, Ice
		$$seespell	Water Vision	Water
		end
	sublist "Light and Darkness" memlist
		$$sp("Colors", , , "Light and Darkness", "1 sec.", "1 min.", "2/1#", "Light>=slc(12)", M57)
		$$sp("Dark Vision", , , "Light and Darkness;*Thief", "1 sec.", "1 min.", "5/2", "Night Vision>=slc(12)|Infravision>=slc(12)", M58)
		$$sp("Hawk Vision", , , "Light and Darkness", "2 sec.", "1 min.", "4/2", "!Dis:Blindness;!Dis:Bad Sight~Keen Eyes>=slc(12)|#5,Sp:Light and Darkness>=slc(12)", M58)
		$$sp("Hide", , , "Light and Darkness;*Thief", "5 sec.", "1 hr.", "1 to 5/s", "Blur>=slc(12)|Forgetfulness>=slc(12)", M58)
		$$sp("Infravision", , , "Light and Darkness", "1 sec.", "1 min.", "3/1", "Keen Eyes>=slc(12)|#5,Sp:Light and Darkness>=slc(12)", M58)
		$$sp("Invisibility", , , "Light and Darkness;*Thief", "3 sec.", "1 min.", "5/3", "#6,Sp:Light and Darkness>=slc(12);Blur>=slc(12)", M58)
		$$sp("Light Jet", , , "Light and Darkness", "1 sec.", "1 min.", "2/1", "Continual Light>=slc(12)|Shape Light>=slc(12)", M57)
		$$sp("Night Vision", , , "Light and Darkness;*Thief", "1 sec.", "1 min.", "3/1", "Keen Eyes>=slc(12)|#5,Sp:Light and Darkness>=slc(12)", M58)
		$$sp("See Invisible", , , "Light and Darkness", "1 sec.", "1 min.", "4/2", "Invisibility>=slc(12)|Dark Vision>=slc(12);Infravision>=slc(12)", M58)
		$$sp("Shape Darkness", "Area", , "Light and Darkness", "1 sec.", "1 min.", "2/2#", "Darkness>=slc(12)", M58)
		end
	sublist "Making and Breaking" memlist
		$$sp("Clean", "Area", , "Making and Breaking", "1 sec.", "Perm.", "2", "Restore>=slc(12)", M60)
		$$sp("Copy/TL", , , "Making and Breaking", "5 sec.", "Perm.", "2 + 1/copy", "Dye>=slc(12)~Advantages:Literacy|Configuration:TL>4-&tl;!Dis:Illiteracy", M60)
		$$sp("Disintegrate*", , , "Making and Breaking", "1 sec.", "Perm.", "1 to 4#", "#1,Adv:Magery>=2;Shatter>=slc(12);Ruin>=slc(12);Earth to Air>=slc(12);Destroy Air>=slc(12);Destroy Water>=slc(12)", M59)
		$$sp("Dye", , , "Making and Breaking", "3 sec.", "2d days", "varies#", "Restore>=slc(12);Colors>=slc(12)", M60)
		$$sp("Knots", , , "Making and Breaking", "3 sec.", "Indef.", "2#", "Stiffen>=slc(12)", M60)
		$$sp("Rejoin", , , "Making and Breaking", "4 sec./10 lbs.", "10 min.", "1 per 10 lbs./h", "Weaken>=slc(12);Restore>=slc(12)", M60)
		$$sp("Repair", , , "Making and Breaking", "1 sec./lb.", "Perm.", "3/10 lbs.", "#1,Adv:Magery>=2;Rejoin>=slc(12)", M60)
		$$sp("Repair Arrow", , , "Making and Breaking", "4 sec./arrow", "Perm.", "2 per arrow", "Rejoin>=slc(12)", M60)
		$$sp("Reshape", , , "Making and Breaking;*Shape", "10 sec.", "1 min.", "6/3", "#1,Adv:Magery>=1;Weaken>=slc(12)~Shape Earth>=slc(12)|Shape Plant>=slc(12)", M59)
		$$sp("Ruin/TL", , , "Making and Breaking", "5 sec./lb.", "1 min.#", "2 per lb./s", "#1,Adv:Magery>=1;Weaken>=slc(12);Decay>=slc(12)", M59)
		$$sp("Sharpen", , , "Making and Breaking", "4 sec.", "1 min.", "Special", "Repair>=slc(12)", M60)
		$$sp("Shatterproof", , , "Making and Breaking", "1 sec.", "1 hr.", "3/3", "Repair>=slc(12);Shatter>=slc(12)", M60)
		$$sp("Stiffen", , "Spec.", "Making and Breaking", "2 sec./lb.", "10 min.", "1 per lb./h#", "Rejoin>=slc(12)", M60)
		end
	sublist "Meta-Spell" memlist
		$$sp("Activate Runes*", , , "Meta-Spell", "1 sec.", "Instant", "none", "#1,Adv:Magery>=1;Skills:Rune-Lore>=12", M92)
		$$sp("Bless", , , "Meta-Spell", "min.=cost", "varies#", "varies#", "#1,Adv:Magery>=2;#2,10,Sp>=slc(12)", M62)
		$$sp("Conceal Magic", , , "Meta-Spell", "3 sec.", "10 hrs.", "1 to 5/s#", "Detect Magic>=slc(12)", M61)
		$$sp("Counterspell", , "Spell", "Meta-Spell", "5 sec.", "Instant", "varies#", "#1,Adv:Magery>=1", M61)
		$$sp("Curse", , , "Meta-Spell", "varies#", "Special", "varies#", "#1,Adv:Magery>=2;#2,10,Sp>=slc(12)", M63)
		$$sp("Delay", , , "Meta-Spell", "10 sec.", "2 hrs.", "3/3", "#15,Spells>=slc(12);#1,Adv:Magery>=3", M63)
		$$sp("Dispel Magic", "Area", "spell", "Meta-Spell", "sec.=cost", "Perm.", "3", "Counterspell>=slc(12);#13,Spells>=slc(12)|Suspend Magic>=slc(12)", M62)
		$$sp("Drain Mana*", "Area", , "Meta-Spell", "1 hr.", "Perm.", "10", "Dispel Magic>=slc(12);#1,10,Sp>=slc(12)", M63)
		$$sp("Drain Mana*", "Area", , "Meta-Spell", "1 hr.", "Perm.", "10", "Dispel Magic>=slc(12);#1,10,Sp>=slc(12);Suspend Mana>=slc(12)", M63)
				dsid ALTS
		$$sp("Great Ward", "Blocking", "Spell", "Meta-Spell", "none", "Instant", "1 per subject#", "#1,Adv:Magery>=2;Ward>=slc(12)", M62)
		$$sp("Link", "Area", , "Meta-Spell;Enchantment", "4 hrs.", "Indef.#", "8", "Delay>=slc(12)", M64)
		$$sp("Magic Resistance", , "IQ+M", "Meta-Spell", "3 sec.", "1 min.", "1 to 5/s", "#1,Adv:Magery>=1;#1,7,Sp>=slc(12)", M61)
		$$sp("Pentagram", "Special", , "Meta-Spell", "5 s./hex#", "Perm.", "10/hex#", "Spell Shield>=slc(12)", M62)
		$$sp("Reflect", "Blocking", "spell", "Meta-Spell", "none", "Instant", "4 or 6#", "Ward>=slc(12)", M62)
		$$sp("Reflex", "Special", , "Meta-Spell", "10 sec.", "1 hr.", "varies#", "Delay>=slc(12);Ward>=slc(12)", M64)
		$$sp("Remove Curse", , "spell", "Meta-Spell", "1 hr.", "Instant", "20", "#1,Adv:Magery>=2;#1,15,Sp>=slc(12)", M63)
		$$sp("Remove Curse", , "spell", "Meta-Spell", "1 hr.", "Instant", "20", "#1,Adv:Magery>=2~#1,15,Sp|Suspend Curse>=slc(12)", M63)
				dsid ALTS
		$$sp("Restore Mana*", "Area", , "Meta-Spell", "1 hr.", "Perm.", "10", "Dispel Magic>=slc(12);#1,10,Sp>=slc(12)", M63)
		$$sp("Scryguard", , , "Meta-Spell", "5 sec.", "10 hrs.", "3/1#", "#1,Adv:Magery>=1", M61)
		$$sp("Scrywall", "Area", , "Meta-Spell", "sec.=cost", "10 hrs.", "3/2", "Scryguard>=slc(12)", M61)
		$$sp("Spell Shield", "Area", , "Meta-Spell", "1 sec.", "1 min.", "3/2", "#1,Adv:Magery>=2;Scryguard>=slc(12);Magic Resistance>=slc(12)", M61)
		$$sp("Ward", "Blocking", "Spell", "Meta-Spell", "none", "Instant", "2 or 3#", "#1,Adv:Magery>=1", M62)
		end
	sublist "Mind Control" memlist
		$$sp("Alertness*", , , "Mind Control", "1 sec.", "10 min.", "2 per#", "#2,Spells:*Keen>=slc(12)", M69)
		$$sp("Avoid", "Area", , "Mind Control", "1 min.", "1 hr.", "3/3", "Hide>=slc(12);Fear>=slc(12);Forgetfulness>=slc(12)", M67)
		$$sp("Berserker", , "IQ", "Mind Control", "4 sec.", "10 min.#", "3/2", "Bravery>=slc(12)", M65)
		$$sp("Charm", , "IQ", "Mind Control", "3 sec.", "1 min.", "6/3", "#1,Adv:Magery>=1;Loyalty>=slc(12);#8,Sp:Mind Control>=slc(12)", M68)
		$$sp("Drunkenness", , "IQ", "Mind Control", "2 sec.", "1 min.", "varies#", "Foolishness>=slc(12);Clumsiness>=slc(12)", M66)
		$$sp("Emotion Control", "Area", "IQ", "Mind Control", "1 sec.", "1 hr.", "2#", "Loyalty>=slc(12)", M68)
		$$sp("Enslave*", , "IQ", "Mind Control", "1 sec.", "Perm.", "30", "Charm>=slc(12);Telepathy>=slc(12)", M68)
		$$sp("False Memory", , "IQ", "Mind Control", "5 sec.", "varies#", "varies#", "Forgetfulness>=slc(12);#7,Sp:Mind Control>=slc(12)", M67)
		$$sp("Forgetfulness", , "IQ or skill", "Mind Control", "10 sec.", "1 hr.", "3/3", "#1,Adv:Magery>=1;Foolishness>=slc(12);Main:IQ>=12", M66)
		$$sp("Great Geas*", , "IQ", "Mind Control", "1 min.", "Perm.", "30", "#1,Adv:Magery>=3;Lesser Geas>=slc(12);#15,Sp:Mind Control>=slc(12)", M68)
		$$sp("Keen Ears", , , "Mind Control;Sound;*Keen", "1 sec.", "30 min.", "1 per +/h#", , M69)
		$$sp("Keen Ears", , , "Mind Control;Sound;*Keen", "1 sec.", "30 min.", "1 per +/h#", "Dull Ears>=slc(12)", M69)
				dsid ALTS
		$$sp("Keen Eyes", , , "Mind Control;*Keen", "1 sec.", "30 min.", "1 per +/h#", , M69)
		$$sp("Keen Eyes", , , "Mind Control;*Keen", "1 sec.", "30 min.", "1 per +/h#", "Dull Eyes>=slc(12)", M69)
				dsid ALTS
		$$sp("Keen Nose", , , "Mind Control;*Keen", "1 sec.", "30 min.", "1 per +/h#", , M69)
		$$sp("Keen Nose", , , "Mind Control;*Keen", "1 sec.", "30 min.", "1 per +/h#", "Dull Nose>=slc(12)", M69)
				dsid ALTS
		$$sp("Lesser Geas*", , "IQ", "Mind Control", "30 sec.", "Perm.", "12", "#1,Adv:Magery>=2;#10,Sp:Mind Control>=slc(12)", M68)
		$$sp("Lesser Geas*", , "IQ", "Mind Control", "30 sec.", "Perm.", "12", "#1,Adv:Magery>=2;Command>=slc(12);#10,Sp:Mind Control>=slc(12)", M68)
				dsid ALTS
		$$sp("Loyalty", , "IQ", "Mind Control", "2 sec.", "1 hr.", "2/2#", "Bravery>=slc(12);#5,Sp:Mind Control>=slc(12)", M68)
		$$sp("Madness", , "IQ-2", "Mind Control", "2 sec.", "1 min.", "4/2", "Forgetfulness>=slc(12)|Drunkenness>=slc(12)", M67)
		$$sp("Mass Suggestion", "Area", "IQ", "Mind Control", "sec. = cost", "10 min.", "4/2#", "Suggestion>=slc(12)", M68)
		$$sp("Mental Stun", , "IQ", "Mind Control", "1 sec.", "Instant", "2", "Daze>=slc(12)|Stun>=slc(12)", M66)
		$$sp("Mindlessness", , "IQ", "Mind Control", "5 sec.", "1 min.", "8/4", "#1,Adv:Magery>=2;Forgetfulness>=slc(12)", M67)
		$$sp("Nightmare", , "IQ", "Mind Control", "1 min.", "1 hr.", "6", "Death Vision>=slc(12);Fear>=slc(12);Sleep>=slc(12);#1,Adv:Magery>=2", M67)
		$$sp("Panic", "Area", "IQ", "Mind Control", "1 sec.", "1 min.", "4/2", "Fear>=slc(12)", M65)
		$$sp("Peaceful Sleep", , "Spec.", "Mind Control", "30 sec.", "8 hrs.", "4", "Sleep>=slc(12)|Silence>=slc(12)", M67)
		$$sp("Permanent Forgetfulness*", , "IQ or skill", "Mind Control", "1 hr.", "Perm.", "15", "#1,Adv:Magery>=2;Forgetfulness>=slc(12);Main:IQ>=13", M66)
		$$sp("Permanent Madness*", , "IQ-2", "Mind Control", "10 min.", "Perm.", "20", "#1,Adv:Magery>=2;Madness>=slc(12);Main:IQ>=13", M67)
		$$sp("Rear Vision", , , "Mind Control", "1 sec.", "1 min.", "3/1", "Alertness>=slc(12)", M69)
		$$sp("Sickness", , "HT", "Mind Control;Body Control", "4 sec.", "1 min.", "3/3", "Drunkenness>=slc(12)|Pestilence>=slc(12)", M66)
		$$sp("Suggestion", , "IQ", "Mind Control", "10 sec.", "10 min.", "4/3", "Emotion Control>=slc(12);Forgetfulness>=slc(12)", M68)
		$$sp("Terror", "Area", "IQ", "Mind Control", "1 sec.", "Instant", "4", "Fear>=slc(12)", M65)
		$$sp("Wisdom", , , "Mind Control", "1 sec.", "1 min.", "varies#", "#6,Sp:Mind Control>=slc(12)", M68)
		end
	sublist "Movement" memlist
		$$sp("Air-Golem", , , "Movement", "10 sec.", "1 hr.", "4/2", "#1,Adv:Magery>=2;Apportation>=slc(12)", M70)
		$$sp("Apportation", , "IQ", "Movement", "1 sec.", "1 min.", "varies#", "#1,Adv:Magery>=1", M69)
		$$sp("Blink", "Blocking", , "Movement;Gate", "1 sec.", "Instant", "2", "Teleport>=slc(12)", M71)
		$$sp("Ethereal Body*", , , "Movement", "30 sec.", "10 sec.", "8/4", "#1,Adv:Magery>=3;Body of Air>=slc(12)|#6,Sp:Movement>=slc(12)", M72)
		$$sp("Flight*", , , "Movement", "2 sec.", "1 min.", "5/3", "Levitation>=slc(12);#1,Adv:Magery>=2", M71)
			textline adj "Sk:Flight+`Add to Skill`*integer(x/8)"
			opt begin text "Add to Skill" "?+0;" dispexp "'l'" noprint end
				end
		$$sp("Glue", "Area", , "Movement", "1 sec.", "10 min.", "3/3", "Haste>=slc(12)", M69)
		$$sp("Great Haste*", , , "Movement", "3 sec.", "10 sec.", "5#", "#1,Adv:Magery>=1;Haste>=slc(12);Main:IQ>=12", M69)
		$$sp("Haste", , , "Movement", "2 sec.", "1 min.", "2/1#", , M69)
		$$sp("Hawk Flight*", , , "Movement", "3 sec.", "1 min.", "8/4", "Flight>=slc(12)", M71)
			textline adj "Sk:Flight+`Add to Skill`*integer(x/8)"
			opt begin text "Add to Skill" "?+0;" dispexp "'l'" noprint end
				end
		$$sp("Levitation", , "IQ", "Movement", "2 sec.", "1 min.", "1 per 80 lbs/h#", "Apportation>=slc(12)", M70)
		$$sp("Lighten Burden", , , "Movement", "3 sec.", "10 min.", "3 or 5/h#", "Apportation>=slc(12)", M69)
		$$sp("Lockmaster", , "Magelock", "Movement", "10 sec.", "Perm.", "3#", 
			"Locksmith>=slc(12)|#1,Adv:Magery>=2;Apportation>=slc(12)", M70)
		$$sp("Locksmith", , , "Movement", "1 sec.", "1 min.#", "2/2", "Apportation>=slc(12)", M70)
		$$sp("Manipulate", , , "Movement", "3 sec.", "1 min.", "4/3#", "Locksmith>=slc(12)", M70)
		$$sp("Poltergeist", "Missile", "HT", "Movement", "1 sec.", "Instant", "1 or 2#", "Apportation>=slc(12)", M70)
		$$sp("Quick March", , , "Movement", "1 min.", "1 day's march", "4#", "#1,Adv:Magery>=1;Haste>=slc(12)", M69)
		$$sp("Slow Fall", , , "Movement", "1 sec.", "1 min.", "1 per 50 lbs./h", "Apportation>=slc(12)", M69)
		$$sp("Swim", , , "Movement;Water", "3 sec.", "1 min.", "6/3", "Shape Water>=slc(12);Levitation>=slc(12)", M70)
		$$sp("Teleport*", "Special", , "Movement;Gate", "1 sec.", "Instant", "varies#", "Main:IQ>=15;#1,10,Sp>=slc(12)|Hawk Flight>=slc(12)", M71)
		$$sp("Teleport Other*", , "IQ+1", "Movement;Gate", "1 sec.", "Instant", "varies#", "Teleport>=slc(12);#1,Adv:Magery>=3", M71)
		$$sp("Undo", , "Spec.", "Movement", "1 sec.", "Instant", "3 or 6#", "Locksmith>=slc(12)", M70)
		$$sp("Wallwalker", , , "Movement", "1 sec.", "1 min.", "1 per 50 lbs./h", "Apportation>=slc(12)", M70)
		$$sp("Winged Knife", "Missile", , "Movement", "1 sec.", "Instant", "1 per lb.#", "Poltergeist>=slc(12)", M72)
		end
	sublist "Necromantic" memlist
		$$sp("Age*", , "HT", "Necromantic", "1 min.", "Perm.", "5 to 50", "#6,Sp:Necromantic>=slc(12);Youth>=slc(12)", M74)
		$$sp("Animation*", , , "Necromantic", "5 sec.", "1 min.", "varies#", "Summon Spirit>=slc(12)", M73)
		$$sp("Banish", "Special", "ST+IQ", "Necromantic;Gate", "5 sec.", "Instant", "Special", "#1,Adv:Magery>=1;#1,10,Sp>=slc(12)", M75)
		$$sp("Control Zombie", , "spell", "Necromantic", "1 sec.", "Perm.", "3", "Zombie>=slc(12)", M73)
		$$sp("Death Vision", , , "Necromantic", "3 sec.", "1 sec.", "2", "#1,Adv:Magery>=1", M72)
		$$sp("Pestilence", , , "Necromantic", "30 sec.", "Perm.", "6", "#1,Adv:Magery>=1;Steal Health>=slc(12);Decay>=slc(12)", M74)
		$$sp("Planar Summons", "Special", , "Necromantic;Gate", "5 min.", "varies#", "20#", "#1,Adv:Magery>=1;#1,10,Sp>=slc(12)", M74)
		$$sp("Sense Spirit", "Information;Area", , "Necromantic", "1 sec.", "Instant", "1/2", "Death Vision>=slc(12)|Sense Life>=slc(12);#1,Adv:Magery>=1", M72)
		$$sp("Skull-Spirit", , , "Necromantic", "1 sec.", "24 hrs.", "20", "#4,Sp:Necromantic>=slc(12)", M73)
		$$sp("Soul Jar*", , , "Necromantic", "1 min.", "Perm.", "8", "#1,Adv:Magery>=1;#6,Sp:Necromantic>=slc(12);Steal Health>=slc(12)", M73)
		$$sp("Steal Health", , , "Necromantic", "1 min./3 HT-#", "Perm.", "none#", "Steal Strength>=slc(12)", M74)
		$$sp("Steal Strength", , , "Necromantic", "1 min./3 ST-#", "Perm.", "none#", "Minor Healing>=slc(12)", M73)
		$$sp("Steal Youth*", , "HT", "Necromantic", "1 hr.", "Perm.", "10 to 30", "Youth>=slc(12);Age>=slc(12);Steal Health>=slc(12)", M74)
		$$sp("Summon Demon", "Special", , "Necromantic;Gate", "5 min.", "1 hr.#", "20", "#1,Adv:Magery>=1;#1,10,Sp>=slc(12)", M74)
		$$sp("Summon Shade*", "Information", "IQ", "Necromantic", "10 min.#", "1 min.", "50/20", "Summon Spirit>=slc(12)", M72)
		$$sp("Summon Spirit", "Information", "IQ", "Necromantic", "5 min.#", "1 min.", "20/10#", "Death Vision>=slc(12);#1,Adv:Magery>=2", M72)
		$$sp("Turn Zombie", "Area", , "Necromantic", "4 sec.", "1 day", "2", "Zombie>=slc(12)|Adv:Clerical Investment", M73)
		$$sp("Zombie", , , "Necromantic", "1 min.", "Perm.", "8#", "Summon Spirit>=slc(12);Lend Health>=slc(12)", M73)
		$$seespell	Resurrection*	Healing
		end
	sublist "Plant" memlist
		$$sp("Animate Plant", , , "Plant", "5 sec.", "1 min.", "varies#", "#7,Sp:Plant>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Bless Plants", "Area", , "Plant", "5 min.", "1 crop/season", "1#", "Heal Plant>=slc(12)", M75, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Create Plant", "Area", , "Plant;*Create", "varies#", "Perm.", "varies#", "Plant Growth>=slc(12);#1,Adv:Magery>=1", M75, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Forest Warning", "Area", , "Plant", "1 sec.", "10 hrs.", "1/2#/s", "#4,Sp:Plant>=slc(12)|Sp:Sense Danger>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Heal Plant", "Area", , "Plant", "1 min.", "Perm.", "3#", "Identify Plant>=slc(12)", M75, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Hide Path", , , "Plant", "1 sec.", "1 min.", "2/1", "Heal Plant>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Identify Plant", "Information", , "Plant", "1 sec.", "Instant", "2", "Seek Plant>=slc(12)", M75, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Plant Form", "Special", , "Plant;*Shifting", "1 sec.", "1 hr.", "5/2", "#1,Adv:Magery>=1;#6,Sp:Plant>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Plant Growth", "Area", , "Plant", "10 sec.", "1 min.", "3/2", "Heal Plant>=slc(12)", M75, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Plant Sense", , "Hide Path", "Plant", "1 sec.", "1 min.", "3/2", "Forest Warning>=slc(12);Hide Path>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Seek Plant", "Information", , "Plant;*Seek", "1 sec.", "Instant", "2", , M75, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Shape Plant", , , "Plant;*Shape", "10 sec.", "1 min.", "3/1#", "Identify Plant>=slc(12)", M75, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Tangle Growth", "Area", , "Plant", "2 sec.", "1 min.", "1 or 2#/h", "Plant Growth>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Wither Plant", "Area", "HT", "Plant", "10 sec.", "Perm.", "2", "Plant Growth>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Wither Plant", "Area", "HT", "Plant", "10 sec.", "Perm.", "2", "Blight>=slc(12)", M76, "TreeKin?asp(~x,iq):hsp(~x,iq)")
			textline dsid ALTS
		end
	sublist "Protection and Warning" memlist
		$$sp("Armor", , , "Protection and Warning", "1 sec.", "1 min.", "varies#", "Repair>=slc(12)", M76)
		$$sp("Armor", , , "Protection and Warning", "1 sec.", "1 min.", "varies#", "Repair>=slc(12);Hardiness>=slc(12)", M76)
				textline dsid ALTS
		$$sp("Force Dome", "Area", , "Protection and Warning", "1 sec.", "10 min.", "3/2", "#1,Adv:Magery>=1;Weather Dome>=slc(12);Apportation>=slc(12)", M78)
		$$sp("Iron Arm", "Blocking", , "Protection and Warning", "1 sec.", "Instant", "1", "Resist Pain>=slc(12);Main:DX>=12", M77)
		$$sp("Magelock", , , "Protection and Warning", "4 sec.", "6 hrs.", "3/2", "#1,Adv:Magery>=1", M77)
		$$sp("Missile Shield", , , "Protection and Warning", "1 sec.", "1 min.", "5/2", "Apportation>=slc(12)|Shield>=slc(12)", M77)
		$$sp("Missile Shield", , , "Protection and Warning", "1 sec.", "1 min.", "5/2", "Deflect Missile>=slc(12)|Shield>=slc(12)", M77)
			textline dsid ALTS
		$$sp("Mystic Mist", "Area", , "Protection and Warning", "5 min.", "10 hrs.", "1/1", "#1,Adv:Magery>=1~Watchdog>=slc(12)|Shield>=slc(12)", M77)
		$$sp("Nightingale", "Area", , "Protection and Warning", "1 sec.", "10 hrs.", "2/2#", "Sense Danger>=slc(12)", M77)
		$$sp("Reverse Missiles", , , "Protection and Warning", "1 sec.", "1 min.", "7/3", "Missile Shield>=slc(12)|Force Dome>=slc(12)", M77)
		$$sp("Sense Danger", "Information", , "Protection and Warning", "1 sec.", "Instant", "3", "Sense Foes>=slc(12)|Adv:Danger Sense", M76)
		$$sp("Shield", , , "Protection and Warning", "1 sec.", "1 min.", "varies#", "#1,Adv:Magery>=2", M76)
		$$sp("Teleport Shield", "Area", , "Protection and Warning;Gate", "10 sec.", "1 hr.", "1/3#/s", "Watchdog>=slc(12)~Spell Shield>=slc(12)|Teleport>=slc(12)", M78)
		$$sp("Utter Dome", "Area", , "Protection and Warning", "1 sec.", "1 min.", "6/4", "#1,Adv:Magery>=2;Force Dome>=slc(12);Spell Shield>=slc(12)", M78)
		$$sp("Watchdog", "Area", , "Protection and Warning", "10 sec.", "10 hrs.", "1/1", "Sense Danger>=slc(12)", M77)
		$$sp("Weather Dome", "Area", , "Protection and Warning", "1 sec.", "6 hrs.", "3/2", "#2,Sp:Air>=slc(12);#2,Sp:Earth>=slc(12);#2,Sp:Fire>=slc(12);#2,Sp:Water>=slc(12)", M78)
		$$seespell	Umbrella	Water
		end
	sublist "Sound" memlist
		$$sp("Sound", , , "Sound", "1 sec.", "varies#", "varies#", , M78)
		$$sp("Delayed Message", "Area", , "Sound", "4 sec.", "Indef.#", "3#", "#1,Adv:Magery>=1;Voices>=slc(12);Sense Life>=slc(12)", M79)
		$$sp("Far-Hearing", "Information", , "Sound;Knowledge", "3 sec.", "1 min.", "4/2", "#1,Adv:Magery>=1;!Dis:Deafness;!Dis:Hard of Hearing;#4,Sp:Sound>=slc(12)", M79)
		$$sp("Great Voice", , , "Sound", "2 sec.", "1 min.", "3/1", "Voices>=slc(12);Thunderclap>=slc(12)", M78)
		$$sp("Hush", , "IQ", "Sound;*Thief", "2 sec.", "10 sec.#", "2/1", "Silence>=slc(12)", M79)
		$$sp("Invisible Wizard Ear", , , "Sound;*Thief", "4 sec.", "1 min.", "5/3", "Wizard Ear>=slc(12);Invisibility>=slc(12)", M79)
		$$sp("Mage-Stealth", , , "Sound;*Thief", "3 sec.", "1 min.", "3/2", "Hush>=slc(12)", M79)
		$$sp("Noise", "Area", , "Sound", "1 sec.", "5 sec.", "4/2", "Wall of Silence>=slc(12)", M79)
		$$sp("Scribe/TL", , , "Sound", "1 sec.", "1 min.", "3/1", "Voices>=slc(12);Adv:Literacy;Air-Golem>=slc(12)", M79)
		$$sp("Silence", "Area", , "Sound", "1 sec.", "1 min.", "2/1", "Sound>=slc(12)", M78)
		$$sp("Sound Jet", , , "Sound", "1 sec.", "1 sec.", "1 to 4#/s", "Great Voice>=slc(12)", M78)
		$$sp("Sound Vision", , , "Sound", "1 sec.", "1 min.", "5/2", "Adv:Acute Hearing|Keen Ears>=slc(12)", M79)
		$$sp("Thunderclap", , , "Sound", "1 sec.", "Instant", "2", "Sound>=slc(12)", M78)
		$$sp("Voices", , , "Sound", "1 sec.", "1 min.", "3/2", "Sound>=slc(12)", M78)
		$$sp("Wall of Silence", "Area", , "Sound;*Thief", "1 sec.", "1 min.", "2/1", "Silence>=slc(12)", M79)
		$$sp("Wizard Ear", , , "Sound;*Thief", "2 sec.", "1 min.", "4/3", "Apportation>=slc(12);Far-Hearing>=slc(12);Sound Vision>=slc(12)", M79)
		$$seespell	Keen Ears	Mind Control
		end
	sublist "Water" memlist
		$$sp("Body of Water", , "HT", "Water;*Shifting", "5 sec.", "1 min.", "5/hex#", "Shape Water>=slc(12)", M40)
		$$sp("Breathe Air", , , "Water", "1 sec.", "1 in.", "4/2", "Create Water>=slc(12);Destroy Air>=slc(12)", M39)
		$$sp("Dehydrate", , "HT", "Water", "2 sec.", "Perm.", "1 to 3#", "#5,Sp:Water>=slc(12);Destroy Water>=slc(12)", M39)
		$$sp("Essential Water", , , "Water", "1 sec.", "Perm.", "3/gal.", "#6,Sp:Water>=slc(12)", M39)
		$$sp("Geyser*", "Area", , "Water", "5 sec.", "1 sec.", "5/2", "#6,Sp:Water>=slc(12)~#4,Sp:Earth>=slc(12)|#4,Sp:Fire>=slc(12)", M42)
		$$sp("Geyser*", "Area", , "Water", "5 sec.", "1 sec.", "5/2", "Create Well>=slc(12);#6,Sp:Water>=slc(12);#4,Sp:Earth>=slc(12)|#6,Sp:Water>=slc(12);#4,Sp:Fire>=slc(12)", M42)
			textline dsid ALTS
		$$sp("Umbrella", , , "Water;Protection and Warning", "2 sec.", "10 min.", "1/1", "Shape Water>=slc(12)|Shield>=slc(12)", M40)
		$$sp("Water Jet", , , "Water", "1 sec.", "1 sec.", "1 to 3#", "Shape Water>=slc(12)", M40)
		$$sp("Water Vision", "Information", , "Water;Knowledge", "1 sec.", "30 sec.", "1/1#", "Shape Water>=slc(12)", M40)
		sublist "Weather" memlist
			$$sp("Frost", "Area", , "Water;*Ice;*Weather", "1 sec.", "varies", "6/hex", "Create Water>=slc(12)|Cold>=slc(12)", M41)
			$$sp("Hail", "Area", , "Water;*Ice;*Weather", "1 sec.", "1 min.", "1/5/s#", "Snow>=slc(12)", M42)
			$$sp("Snow", "Area", , "Water;*Ice;*Weather", "1 sec.", "1 hr.", "1/15#", "Clouds>=slc(12);Frost>=slc(12)", M42)
			$$seespell	Rain	Air Water
			end
		sublist "Ice" memlist
			$$sp("Freeze", , , "Water;*Ice", "10 sec.", "varies#", "6/hex#", "Shape Water>=slc(12)", M41)
			$$sp("Frostbite", , "HT", "Water;*Ice", "3 sec.", "Perm.", "1 to 3#", "#5,Sp:Water>=slc(12);Frost>=slc(12);Freeze>=slc(12)", M42)
			$$sp("Ice Dagger", "Missile", , "Water;*Ice", "1-3 sec.", "Instant", "1-3#", "Ice Sphere>=slc(12)", M41)
			$$sp("Ice Slick", "Area", , "Water;*Ice", "2 sec.#", "varies#", "3", "Frost>=slc(12)", M41)
			$$sp("Ice Vision", , , "Water;Knowledge;*Ice", "1 sec.", "30 sec.", "2/10 yds.#", "Shape Water>=slc(12)", M41)
			$$sp("Icy Weapon", , , "Water;*Ice", "3 sec.", "1 min.", "3/1", "Create Water>=slc(12)", M40)
			$$sp("Melt Ice", "Area", , "Water;*Ice", "10 sec.", "Perm.#", "1#", "Heat>=slc(12)|Freeze>=slc(12)", M41)
			$$sp("Snow Shoes", , , "Water;*Ice", "2 sec.", "1 min.", "2/1", "Shape Water>=slc(12)", M41)
			end
		end

	sublist "College Skills" memlist
		$$spCollege	Air
		$$spCollege	Animal
		$$spCollege	Body Control
		$$spCollege	Communication and Empathy
		$$spCollege	Divination
		$$spCollege	Earth
		$$spCollege	Enchantment
		$$spCollege	Fire
		$$spCollege	Food
		$$spCollege	Gate
		$$spCollege	Healing
		$$spCollege	Ice
		$$spCollege	Illusion and Creation
		$$spCollege	Knowledge
		$$spCollege	Light and Darkness
		$$spCollege	Making and Breaking
		$$spCollege	Meta-Spell
		$$spCollege	Mind Control
		$$spCollege	Movement
		$$spCollege	Necromantic
		$$spCollege	Plant
		$$spCollege	Protection and Warning
		$$spCollege	Sound
		$$spCollege	Water
		$$spCollege	Weather
		end
	end

cat Jobs 
	colwidth 1 100 
	sublist Magic 
		colwidth 9 49 129 47 341 56 100 100 100 100 
		sort 2 
		memlist 
		$$job	Apprentice	2	Adv:Magery|Main:IQ>=12	100	IQ	LJ/4d
		$$job	Village Hedge Wizard*	2	$totalItemValues('Spells', 'level')>=80::$format('Useful spell levels at least 80 (have %d)',totalItemValues('Spells', 'level'))	400	IQ-1	3d/LJ,5d
		$$job	Wizardly Thief*	2		400		3d,jailed,LJ/6d,jailed,LJ
		$$job	Guard Wizard	3	$totalItemValues('Spells:Combat', 'level')>=100::$format('Combat spell levels at least 100 (have %d)',totalItemValues('Spells:Combat', 'level'))	600	findItemValue('Spells:Combat', 'max', 'level')-2	3d/LJ,5d
		$$job	Soldier Wizard	3	$totalItemValues('Spells:Combat', 'level')>=100::$format('Combat spell levels at least 100 (have %d)',totalItemValues('Spells:Combat', 'level'))	600	findItemValue('Spells:Combat', 'max', 'level')-2	3d/LJ,5d
		$$job	Town Wizard*	3	$totalItemValues('Spells', 'level')>=100::$format('Useful spell levels at least 100 (have %d)',totalItemValues('Spells', 'level'))	500	IQ	-2i/-1i,4d,LJ
		$$job	Enchanter	4	Sp:Enchant>=15;$totalItemValues('Spells', 'level')-Enchant>=100::$format('Other useful spell levels at least 100 (have %d)',totalItemValues('Spells', 'level')-Enchant)	50*Enchant	Enchant-1	-3i,3d/-4i,5d,LJ
		$$job	Alchemist*	4	Skill:Alchemy>=14	50*Alchemy	Alchemy-1	-2i,3d/-3i,5d,LJ
		$$job	Court Wizard	4	$totalItemValues('Spells', 'level')>=200::$format('Spell levels at least 200 (have %d)',totalItemValues('Spells', 'level'));Adv:Status>=1~Sk:Diplomacy>=15|Sk:Politics>=15|Sk:Savoir-Faire>=15	20*(Diplomacy+Politics+SavoirFaire)	max(Diplomacy,Politics,SavoirFaire)	-2i,3d/-3i,5d,LJ
		$$job	Master Enchanter*	5	Sp:Enchant>=20;$totalItemValues('Spells', 'level')-Enchant>=200::$format('Other useful spell levels at least 200 (have %d)',totalItemValues('Spells', 'level')-Enchant)	75*Enchant	Enchant-2	-4i,3d/-5i,5d,LJ
		$$job	Guildmaster	5	$totalItemValues('Spells', 'level')>=400::$format('Spell levels at least 400 (have %d)',totalItemValues('Spells', 'level'));Adv:Status>=2~Sk:Diplomacy>=15|Sk:Politics>=15|Sk:Savoir-Faire>=15	30*(Diplomacy+Politics+SavoirFaire)	max(Diplomacy,Politics,SavoirFaire)	-3i,3d/-4i,6d,LJ
		$$job	High Court Wizard	5	$totalItemValues('Spells', 'level')>=400::$format('Spell levels at least 400 (have %d)',totalItemValues('Spells', 'level'));Adv:Status>=2~Sk:Diplomacy>=15|Sk:Politics>=15|Sk:Savoir-Faire>=15	30*(Diplomacy+Politics+SavoirFaire)	max(Diplomacy,Politics,SavoirFaire)	-3i,3d/-4i,6d,LJ
		end 
	end 


cat Equipment
	sublist Elixirs memlist
		## name, purpose, cat, matcost, time, skill, cost, form)
		sublist "Animal Control" memlist
			$$elix	Cadmus	Dragonslaying	Animal Control	$600+	4 wks		$1300/$2000
			$$elix	Ibycus	Bird Control	Animal Control	$200	2 wks		$550/$900	Potion;Powder;Unguent
			$$elix	Melampus	Beast-Speech	Animal Control	$300	3 wks		$850/$1350	Unguent
			end
		sublist "Combat" memlist
			$$elix	Achilles	Invulnerability	Combat	$1000	6 wks	-3	$2100/$3100
			$$elix	Antaeus	Endurance	Combat	$300	6 wks		$1400/$2400
			$$elix(Ares, the Warrior, Combat, $150, 2 wks, -1, $350/$700, Potion;Powder)
			$$elix(Atalanta, Speed, Combat, $200, 3 wks, , $550/$850, Potion;Powder;Unguent)
			$$elix(Heracles, Strength, Combat, $100, 2 wks, -1, $250/$500, Potion;Powder)
			$$elix(Hermes, Stealth, Combat, $300, 3 wks, -1, $500/$2000, Unguent)
			$$elix(Orion, the Huntsman, Combat, $200, 1 wks, , $300/$400)
			$$elix(Theseus, Leadership, Combat, $400, 7 wks, , $1650/$2850, Potion)
			end
		sublist "Hostile" memlist
			$$elix(Bellerophon, Odiousness, Hostile, $300, 4 wks, , $1000/$1700)
			$$elix(Eris, Madness, Hostile, $100, 1 wks, , $200/$400)
			$$elix(Juno, Jealousy, Hostile, $50, 2 wks, , $400/$700)
			$$elix(Narcissus, Self-Love, Hostile, $20, 4 wks, , $750/$1450, Powder;Pastille;Unguent)
			$$elix(Nemesis, Hatred, Hostile, $125, 1 wk, , $300/$500)
			$$elix(Phobos, Fear, Hostile, $50, 1 wk, , $225/$400, Potion;Pastille)
			$$elix(Philoctetes, Weakness, Hostile, $50, 2 wks, , $400/$750)
			$$elix(Priapus, Lecherousness, Hostile, $200,  10 days, , $500/$700)
			$$elix(Sisyphus, Frustration, Hostile, $100, 3 wks, , $650/$1150)
			$$elix(Tantalus, Foolishness, Hostile, $150, 2 wks, , $500/$850)
			$$elix(Thanatos, Death, Hostile, $100, 2 wks, , $500/$800)
			$$elix(Tithonus, Aging, Hostile, $300, 3 wks, , $825/$1350)
			end
		sublist Magical memlist
			$$elix(Agni, Fire Resistance, Magical, $300, 1 wks, , $500/$700, Potion)
			$$elix(Circe, Transformation, Magical, $800, 12 wks, , $3000/$5000, Potion;Powder)
			$$elix(Daedalus, Flight, Magical, $500, 10 wks, -2, $3000/$4700, Potion;Powder)
			$$elix(Delphi, True Sight, Magical, $200, 4 wks, -1, $550/$1300, Unguent)
			$$elix(Ephialtes, Water-Walking, Magical, $150, 3 wks, , $700/$1200, Potion;Powder)
			$$elix(Odysseus, Invisibility, Magical, $1000, 16 wks, -3, $3000/$6000, Potion)
			$$elix(Poseidon, Water-Breathing, Magical, $50, 5 wks, -1, $600/$1000, Potion)
			$$elix(Tyche, Luck, Magical, $200, 6 wks, -2, $1300/$2300, Powder;Pastille;Unguent)
			end
		sublist Medical memlist
			$$elix(Aesculapius, Health, Medical, $200, 4 wks, -1, $750/$1200, Potion)
			$$elix(Ceres, Fertility, Medical, $1500, 20 wks, -4, $6000/$11000, Potion)
			$$elix(Chiron, Healing, Medical, $50, 1 wk, , $120/$250, Potion;Unguent)
			$$elix(Epimenides, Long Slumber, Medical, $4500, 25 wks, , $9000/$14000)
			$$elix(Hebe, Youth, Medical, $6000, 50 wks, -8, $25000/$60000, Potion)
			$$elix(Hydra, Regeneration, Medical, $300, 20 wks, -3, $5000/$11000, Unguent)
			$$elix(Janus, Antidote, Medical, 250$, 2 wks, -2, $400/$1000, Potion;Powder;Unguent)
			$$elix(Morpheus, Sleep, Medical, $50, 1 wk, , $120/$250)
			$$elix(Persephone, Resurrection, Medical, $12000, 50 wks, -5, $25000/$40000, Potion)
			$$elix(Pluto, Reanimation, Medical, $2000, 12 wks, -2, $4100/$6200, Unguent)
			end
		sublist "Mental Abilities" memlist
			$$elix(Apollo, Foreknowledge, Mental Abilities, $200, 10 wks, , $2000/$3700, Powder)
			$$elix(Epmetheus, Memory, Mental Abilities, $400, 6 wks, , $1500/$2500, Potion;Powder)
			$$elix(Orpheus, Charisma, Mental Abilities, $100, 3 wks, -1, $350/$550, Powder;Unguent)
			$$elix(Prometheus, Wisdom, Mental Abilities, $600, 5 wks, -1, $1500/$2400, Potion;Powder)
			end
		sublist "Mental Control" memlist
			$$elix(Eros, Love, Mental Control, $600, 3 wks, -2, $900/$2000)
			$$elix(Pan, Drunkenness, Mental Control, $100, 3 days, , $130/$300, Powder)
			$$elix(Philemon, Friendship, Mental Control, $300, 2 wks, , $550/$1000)
			end
		sublist "Skills and Physical Abilities" memlist
			$$elix(Argus, Vision, Physical Ability, $250, 10 days, , $400/$700, Unguent)
			$$elix(Marsyas, Music, Skill, $150, 4 days, , $300/$400)
			$$elix(Syrinx, Hearing, Physical Ability, $125, 1 wk, , $300/$500, Unguent)
			$$elix(Vulcan, Craftsmanship, Skill, $400, 4 wks, -1, $1100/$1800)
			end
		end

	sublist "Rune Stones" memlist
		$$equip("Set of Common Rune Stones", .25, 250)
		$$rune("Create", 15000)
		$$rune("Control", 15000)
		$$rune("Heal", 15000)
		$$rune("Transform", 15000)
		$$rune("Sense", 15000)
		$$rune("Communicate", 7500)
		$$rune("Weaken", 7500)
		$$rune("Strengthen", 7500)
		$$rune("Move", 7500)
		$$rune("Protect", 7500)
		$$rune("Warn", 7500)
		$$rune("Earth", 15000)
		$$rune("Animal", 15000)
		$$rune("Magic", 15000)
		$$rune("Body (Man)", 15000)
		$$rune("Mind", 15000)
		$$rune("Undead (Spirit)", 15000)
		$$rune("Air", 7500)
		$$rune("Fire", 7500)
		$$rune("Water", 7500)
		$$rune("Plant", 7500)
 		$$rune("Illusion", 7500)
		$$rune("Light/Dark", 7500)
		$$rune("Food", 100)
		$$rune("Sound", 100)
		end
	end
end 
